%%% ==== This is to perform a classification based on a given feature
%%% vector Mzs. 
%%% It works with LOUT (one patient is left out from training and used
%%% later in prediction step.
%%% Input:
%%%         1. Feature vector Mzs (from SAM analysis)
%%%         2. X: Molecular Data with a patient originally excluded before performing tSNE. To train a classifier.
%%%         3. Test: Data of unseen patient.
%%% Output:
%%%         1.Percentage_TestLabels: represents the percentage of existence
%%%         of certain subpopulations for this unseen patient
%%% =======================================================================

% % % PatientID = 63;
% Index_PatientSubPopulation = find((region_overview(goodlist>0)==PatientID)& (IDXs==subpop));
Index_UnseenPatient = find(pixel_to_sample_ID(goodlist>0)==SelectedPatient);
Tumors_UnseenPatient = Tumors_All(Index_UnseenPatient,:);

ii = find(pixel_to_sample_ID(goodlist>0)~=SelectedPatient); %exclude this patient
ALLTumors_OnePatientExcluded = Tumors_All(ii,:);
clear X Y

for i=1:length(Mzs)
ij = find (peak_list(:,1) ==Mzs(i)); % coloring by mz
X(:,i) = ALLTumors_OnePatientExcluded(:,ij); 
Y(:,i) = Tumors_UnseenPatient(:,ij);
end

Train = X;
Test_Data = Y;
Train_Labels = NewLabels_IDXs;


%% ==========KNN Classifier===============
NBModel = ClassificationKNN.fit(Train,Train_Labels,'NumNeighbors',5);
TestClass = predict(NBModel,Test_Data);
% ==========End KNN Classifier===============

Labels_Unique = unique(NewLabels_IDXs);
nLabels = length(Labels_Unique);
Percentage_TestLabels = [];
for L_ID=1:nLabels
Label_1 = 100*(length(find(TestClass==Labels_Unique(L_ID)))./size(TestClass,1));
Percentage_TestLabels = [Percentage_TestLabels,Label_1];
end
Percentage_TestLabels